<?php 
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/includeBaseComponenti.php";
    include "../../../template/stile.php";
    
    if(isset($_GET["id"])) {
        $elemento = $geecomDb->leggiSingolaRiga("geec_elementiCruscotto",filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT));
        $datiOccorrenza = $geecomDb->leggiSingolaRiga("geec_cruscotti",$elemento["idCruscotto"]);
    }
    
    $arrayDimensioniIcona = array("fa-2x"=>"2x","fa-3x"=>"3x","fa-5x"=>"5x","fa-7x"=>"7x","fa-10x"=>"10x");
    $arrayColori          = array("Primary","Secondary","Info","Light","Dark","Warning","Danger");
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "../include/cssBaseComponenti.php";
        ?>
        <title>Geecom Admin - Creazione elemento</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "../../include/barraSuperiore.php";

                include "../../include/header.php";

                include "../../include/barraMenu.php";
            ?>
        </header>
	
        <main role="main" class="bg-light" id="main">
            <div class="container-fluid">

                <?php 
                    if(isset($_GET["status"])) {
                        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
                    }
                    else {
                        $status = 0;
                    }

                ?>
                    <div class="row py-4">
                        <?php 
                            if($status==200) {
                                echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Elemento modificato
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                  <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                            else if($status==210) {
                                 echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Elemento duplicato, modificalo per non avere due elementi uguali
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                  <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                        ?>
                        
                        <div class="col-12">
                            <div class="form-row justify-content-between mb-3">
                                <div class="col-auto d-flex">
                                    <nav aria-label="breadcrumb" class="align-self-center">
                                        <ol class="breadcrumb p-0 mb-1 mb-md-0 bg-transparent">
                                            <li class="breadcrumb-item"><a href="../../home.php">Home</a></li>
                                            <li class="breadcrumb-item"><a href="#" data-toggle="modal" data-target="#menu-componenti">Componenti</a></li>
                                            <li class="breadcrumb-item"><a href="index.php">Cruscotto</a></li>
                                            <li class="breadcrumb-item"><a href="creaCruscotto.php?id=<?= $datiOccorrenza["id"] ?>"><?= $datiOccorrenza["nome"] ?></a></li>
                                            <li class="breadcrumb-item active" aria-current="page"><?= (isset($elemento)? $elemento["nome"] : "Nuovo elemento") ?></li>
                                        </ol>
                                    </nav>
                                </div>
                                <div class="col-auto text-right">
                                    <a class="btn btn-outline-primary" href="creaCruscotto.php?id=<?= $datiOccorrenza["id"] ?>"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                    <button class="btn btn-primary" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                                    <button type="button" class="btn btn-warning mt-2 mt-lg-0" onclick="location.href='controller/controllerComponente.php?id=1&idElemento=<?= $elemento["id"] ?>&operazione=duplicaElemento';"><i class="far fa-clone mr-2"></i>Duplica</button>
                                </div>
                            </div>
                            <div class="card mb-4 box-shadow-lite">
                                <form name="formComponente" action="controller/controllerComponente.php" method="post">
                                    
                                    <input type="text" class="d-none" name="operazione" value="modificaElemento">
                                    <input type="text" class="d-none" name="id" value="<?=((isset($elemento) ? $elemento["idCruscotto"] : "0")); ?>">
                                    <input type="text" class="d-none" name="idElemento" value="<?=((isset($elemento) ? $elemento["id"] : "0")); ?>">

                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-lg-12">
                                                <div class="row">
                                                    <div class="form-group col-md-3">
                                                        <label>Elemento</label>
                                                        <input type="text" class="form-control" id="nomeSlider" name="nome" aria-describedby="etichetta" value="<?=((isset($elemento) ? $elemento["nome"] : "")) ?>" placeholder="Etichetta">
                                                    </div>
                                                    
                                                    <div class="col-md-3 form-group">
                                                        <label>Spazio occupato</label>
                                                        <select class="form-control" name="spazioOccupato">
                                                        <?php 
                                                            $arrayDimensioniColonna = ["col-12"=>"intera riga","col-lg-10"=>"5/6 della riga","col-lg-8"=>"2/3 della riga", "col-md-6"=>"1/2 della riga","col-md-4"=>"1/3 della riga","col-md-6 col-lg-3"=>"1/4 della riga","d-none"=>"nascosto"];
                                                            foreach($arrayDimensioniColonna as $classe=>$descrizione) {
                                                                if(isset($elemento) && $elemento["spazioOccupato"]==$classe) {
                                                                    echo"<option value=\"$classe\" selected>$descrizione</option>";
                                                                }
                                                                else {
                                                                    echo"<option value=\"$classe\">$descrizione</option>";
                                                                }
                                                            }
                                                        ?>
                                                        </select>
                                                        <small class="text-muted">Lo spazio orizzontale occupato dall'elemento</small>
                                                    </div>
                                                    
                                                    <div class="form-group col-md-3">
                                                        <label for="titolo-articolo">Stile</label>
                                                        <select name="stile" class="form-control" onchange="aggiornaCampiOpzionali()">
                                                            <?php 
                                                                $stiliDisponibili = array("Aspetto 1","Aspetto 2");
                                                                foreach($stiliDisponibili as $stile) {
                                                                    if($elemento["stile"]==$stile) {
                                                                        echo"<option value=\"$stile\" selected>$stile</option>";
                                                                    }
                                                                    else {                                                                    
                                                                        echo"<option value=\"$stile\">$stile</option>";
                                                                    }
                                                                }
                                                            ?>
                                                        </select>
                                                        <small class="text-muted">Seleziona lo stile dell'elemento</small>
                                                    </div>
                                                    
                                                    <div class="form-group col-md-3">
                                                        <label for="titolo-articolo">Icona</label>
                                                        <input type="text" class="form-control" name="icona" value="<?= $elemento["icona"] ?>">
                                                        <small class="text-muted">L'icona mostrata a sinistra nell'elemento</small>
                                                    </div>
                                                    
                                                    <div class="w-100"></div>
                                                    
                                                    <div class="form-group col-md-3">
                                                        <label for="titolo-articolo">Colore sfondo</label>
                                                        <select class="form-control" name="coloreSfondo">
							    <?php 
								foreach($arrayColori as $colore) {
								    if($elemento["coloreSfondo"]==$classe) {
									echo"<option value=\"$colore\" selected>$colore</option>";
								    }
								    else {
									echo"<option value=\"$colore\">$colore</option>";
								    }
								}
							    ?>
                                                        </select>
                                                    </div>
                                                         
                                                    <div class="form-group col-md-3">
                                                        <label for="titolo-articolo">Colore testi</label>
                                                        <select class="form-control" name="coloreTesti">
							    <option value="white">Bianco</option>
							    <?php 
								foreach($arrayColori as $colore) {
								    if($elemento["coloreTesti"]==$colore) {
									echo"<option value=\"$colore\" selected>$colore</option>";
								    }
								    else {
									echo"<option value=\"$colore\">$colore</option>";
								    }
								}
							    ?>
                                                        </select>
                                                    </div>
							     
                                                    <div class="form-group col-md-3">
                                                        <label for="titolo-articolo">Classi aggiuntive</label>
                                                        <input type="text" class="form-control" name="classiAggiuntive" value="<?= $elemento["classiAggiuntive"] ?>">
                                                        <small class="text-muted">Il valore di default del campo input</small>
                                                    </div>
                                                    
                                                    <div id="divStilePulsanti" class="<?= (isset($elemento) && $elemento["stile"]=="Aspetto 2") ? "form-group col-md-3" : "d-none" ?>">
                                                        <label for="titolo-articolo">Stile pulsanti</label>
                                                        <select class="form-control" name="stilePulsanti">
							    <?php 
								foreach($arrayColori as $colore) {
								    if($elemento["stilePulsanti"]==$colore) {
									echo"<option value=\"$colore\" selected>$colore</option>";
								    }
								    else {
									echo"<option value=\"$colore\">$colore</option>";
								    }
								}
							    ?>
                                                        </select>
                                                    </div>
                                                   
                                                    <div id="divEtichettaPulsante1" class="<?= (isset($elemento) && $elemento["stile"]=="Aspetto 2") ? "form-group col-md-3" : "d-none" ?>">
                                                        <label for="titolo-articolo">Etichetta pulsante 1</label>
                                                        <input type="text" class="form-control" name="etichettaPulsante1" value="<?= $elemento["etichettaPulsante1"] ?>">
                                                        <small class="text-muted">Il valore di default del campo input</small>
                                                    </div>
                                                    
                                                    <div id="divEtichettaPulsante2" class="<?= (isset($elemento) && $elemento["stile"]=="Aspetto 2") ? "form-group col-md-3" : "d-none" ?>">
                                                        <label for="titolo-articolo">Etichetta pulsante 2</label>
                                                        <input type="text" class="form-control" name="etichettaPulsante2" value="<?= $elemento["etichettaPulsante2"] ?>">
                                                        <small class="text-muted">Il valore di default del campo input</small>
                                                    </div>
                                                          
                                                    <div class="form-group col-md-3">
                                                        <label for="titolo-articolo">Link pulsante 1</label>
                                                        <input type="text" class="form-control" name="linkPulsante1" value="<?= $elemento["linkPulsante1"] ?>">
                                                        <small class="text-muted">Il valore di default del campo input</small>
                                                    </div>
                                                    
                                                   <div id="linkEtichettaPulsante2" class="<?= (isset($elemento) && $elemento["stile"]=="Aspetto 2") ? "form-group col-md-3" : "d-none" ?>">
                                                        <label for="titolo-articolo">Link pulsante 2</label>
                                                        <input type="text" class="form-control" name="linkPulsante2" value="<?= $elemento["linkPulsante2"] ?>">
                                                        <small class="text-muted">Il valore di default del campo input</small>
                                                    </div>
                                                    
                                                    <div class="w-100"></div>
                                                
                                                    <div class="form-group col-md-3">
                                                        <label for="titolo-articolo">Valore mostrato</label>
                                                        <select class="form-control" name="valoreMostrato">
							    <?php 
                                                                $tipiCampo = array("Valore inserito manualmente","Genera con query");
                                                                foreach($tipiCampo as $tipo) {
                                                                    if($elemento["valoreMostrato"]==$tipo) {
                                                                        echo"<option value=\"$tipo\" selected>$tipo</option>";
                                                                    }
                                                                    else {                                                                    
                                                                        echo"<option value=\"$tipo\">$tipo</option>";
                                                                    }
                                                                }
							    ?>
                                                        </select>
                                                    </div>

                                                   <div class="form-group col-md-3">
                                                        <label for="titolo-articolo">Valore da mostrare</label>
                                                        <input type="text" class="form-control" name="valoreDaMostrare" value="<?= $elemento["valoreDaMostrare"] ?>">
                                                        <small class="text-muted">Il valore di default del campo input</small>
                                                    </div>
                                                    
						     <hr class="w-100">
				                    <div class="col-lg-4 col-xl-3">
				                        <form>
				                            <div class="mb-4 add-box align-self-start sticky-top">
				                                <h5 class="mb-3"> Costruisci la query</h5>
				                                <div class="options-box">
				                                    <div class="form-group">
				                                        <label>Tabella di origine</label>
				                                        <select id="tipoElemento" class="form-control">
				                                            <?php 
				                                                $tipiCampo = array("Testo","Email","Checkbox","Tendina","Area testo","Data","Orario","Link pagina Cruscotto");
				                                                foreach($tipiCampo as $tipo) {
				                                                    echo"<option value=\"$tipo\">$tipo</option>";
				                                                }
				                                            ?>
				                                        </select>
				                                    </div>
				                                    
				                                    <div class="form-group">
				                                        <label>Restrizioni</label>
				                                        <select id="tipoElemento" class="form-control">
				                                            <?php 
				                                                $tipiCampo = array("Restringi al singolo utente","Restringi al gruppo di utenti");
				                                                foreach($tipiCampo as $tipo) {
				                                                    echo"<option value=\"$tipo\">$tipo</option>";
				                                                }
				                                            ?>
				                                        </select>
				                                    </div>
				                                    <button type="button" class="btn btn-primary float-right" value="Crea" onclick="creaElemento()"><i class="fas fa-plus mr-2"></i>Crea</button>
				                                </div>
				                            </div>
				                        </form>
				                    </div>

				                    <div id="divElencoElementi" class="col-lg-8 col-xl-9 mb-4 gerarchia-menu">
				                        <textarea class="form-control" name="query" rows="3"><?= $elemento["query"] ?></textarea>
				                    </div>
                                                </div>   
                                            </div><!--/Colonna principale -->
                                        </form>
                                        </div>
                                    </div>
                                    <div class="card-footer">
                                        <button type="button" class="btn btn-primary float-right" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                                    </div>
                                </div>
                            </div>
                        
                            </div>
                        </div>
           
                    </form>
                </div>
            </div>
        </main>

        <?php 
            include "../../include/footer.php";

            include "../include/modal/cambiaPassword.php";

            include "../../include/modal/modalMenuComponenti.php";

            include "../../include/modal/operazioneCompletata.php";

            include "../include/jsBaseComponenti.php";
        ?>
        
        <!-- Dropzone -->
        <script type="text/javascript" src="../../../plugins/dropzone/dropzone.js"></script>
        <script>
            $("#frmFileUpload-00").dropzone({
                acceptedFiles: ".jpeg,.jpg,.png,.gif,.svg",
                maxFiles: 1,
                addRemoveLinks: true,
                dictRemoveFile: "Rimuovi",
                success: function(file,response) {
                    document.getElementById("immagineElemento").src=response;
                    this.removeAllFiles();
                },
                params:{
                    operazione:"modificaImmagineElemento",
                    idElemento:<?= $elemento["id"] ?>
                },
                maxfilesexceeded: function(file) {
                    this.removeAllFiles();
                    this.addFile(file);
                }
            })
            
            function aggiornaCampiOpzionali() {
                var tipoElemento = document.getElementById("tipoElemento").value;
                if(tipoElemento=="Tendina") {
                    document.getElementById("divOpzioniElemento").className = "form-group col-md-4";
                    document.getElementById("divPlaceholder").className = "d-none";
                }
                else {
                    document.getElementById("divOpzioniElemento").className = "d-none";
                    document.getElementById("divPlaceholder").className = "form-group col-md-4";
                }
            }
        </script>

    </body>
</html>
